<?php

namespace Mtc\Basket\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;

/**
 * Class BasketAjax
 *
 * @package Mtc\Basket\Http\Resources
 */
class ProductSearchResponse extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource = $this->resource
            ->flatten(1)
            ->take($request->input('limit', 20))
            ->each(function ($purchasable) {
                $purchasable->price = $purchasable->getPrice()->raw();
                $purchasable->setVisible([
                    'node_id',
                    'attribute_values',
                    'search_name',
                    'name',
                    'price',
                    'sku',
                    'basket_image',
                    'stock'
                ]);
            });

        return parent::toArray($request);
    }
}
