<?php

namespace Mtc\Basket\Validators;

use Illuminate\Http\Request;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Class BaseBasketValidator
 *
 * @package Mtc\Basket
 */
class BaseBasketValidator
{
    /**
     * @var BasketRepositoryInterface
     */
    protected $repository;

    /**
     * @var Basket
     */
    protected $basket;

    /**
     * BaseBasketValidator constructor.
     *
     * @param BasketRepositoryInterface $repository
     */
    public function __construct(Request  $request, BasketRepositoryInterface $repository)
    {
        $this->request = $request;
        $this->repository = $repository;
        $this->basket = $repository->getModel();
    }

}
