<?php

namespace Mtc\Basket\Http\Resources;

use Illuminate\Http\Request;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Foundation\Country;
use Mtc\Basket\Address;
use Mtc\Foundation\Http\Resources\CountryList;
use Mtc\ShippingManager\Facades\Shipping;

/**
 * Class BasketAjax
 *
 * @package Mtc\Basket\Http\Resources
 */
class BasketTemplateResponses
{
    /**
     * Basket page template
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     * @return string
     */
    public function basket(Request $request, BasketRepositoryInterface $basket)
    {
        return template('basket/index.twig', [
            'segments' => config('basket.basket_page_structure', []),
        ]);
    }

    /**
     * Checkout page template
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     * @return string
     */
    public function checkout(Request $request, BasketRepositoryInterface $basket)
    {
        $countries = Country::query()
            ->with('states')
            ->where('status', 1)
            ->get();

        $address = Address::$blueprint;
        $address['country'] = config('foundation.primary_country');

        return template('checkout/index.twig', [
            'countries' => new CountryList($countries),
            'shipping_types' => Shipping::enabledTypes(),
            'collect_locations' => Shipping::collectLocations($basket),
            'empty_address' => $address,
        ]);
    }
}
