<?php

namespace Mtc\Basket;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Line
 *
 * @package Mtc\Basket
 */
class Line extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'basket_item_lines';

    /**
     * Columns that cannot be mass assigned
     *
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Touch (update) relationship when changes are made
     *
     * @var array
     */
    protected $touches = [
        'item',
    ];

    /**
     * Cast attributes to types
     *
     * @var array
     */
    protected $casts = [
        'data' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];


    /**
     * Hide attributes from ajax response
     *
     * @var array
     */
    protected $hidden = [
        'basket_item_id',
        'created_at',
        'updated_at',
    ];

    /**
     * Relationship with Basket
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        return $this->belongsTo(Item::class);
    }

}
