<?php

namespace Mtc\Basket;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Foundation\Rules\ValidPhoneNumber;
use Mtc\Foundation\Rules\ValidPostcode;

/**
 * Class BasketValidator
 *
 * @package Mtc\Basket
 */
class BasketValidator
{
    /**
     * @var BasketRepositoryInterface
     */
    protected $repository;

    /**
     * @var Basket
     */
    protected $basket;

    /**
     * BasketValidator constructor.
     *
     * @param BasketRepositoryInterface $repository
     */
    public function __construct(Request  $request, BasketRepositoryInterface $repository)
    {
        $this->request = $request;
        $this->repository = $repository;
        $this->basket = $repository->getModel();
    }

    /**
     * Validate the basket
     *
     * @return array
     */
    public function validate()
    {
        return [
            'items' => $this->checkItems(),
        ];
    }

    /**
     * Check if basket items are valid
     *
     * @return bool
     */
    protected function checkItems()
    {
        if (config('basket.allow_backorders') !== true || config('basket.check_stock_on_items_when_basket_doesnt_check_stock')) {
            $passes = $this->checkItemsOutOfStock();
        }

        return config('basket.allow_backorders') ? true : $passes;
    }

    /**
     * Check if stock values are ok for the basket
     *
     * @return bool
     */
    protected function checkItemsOutOfStock()
    {
        return collect($this->basket->items)
            ->filter(function ($item) {
                $item->in_stock = $item->purchasable->getStock() >= $item->quantity;
                return !$item->in_stock;
            })
            ->count() == 0;
    }
}
