<?php

namespace Mtc\Basket\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Basket\Providers\BasketServiceProvider;

/**
 * Class InstallBasket
 *
 * @package Mtc\ShippingManager
 */
class InstallBasket extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:basket';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Basket default assets/data';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Basket');

        $this->callSilent('vendor:publish', [
            '--provider' => BasketServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->comment('Setting up database');
        $this->callSilent('migrate');

        $this->info('Basket installed successfully.');
    }
}
