<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class AddDiscountablesToBasketDiscounts
 */
class AddDiscountablesToBasketDiscounts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('basket_discounts', function (Blueprint $table) {
            $table->text('applicable_items')->nullable()->after('discount_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('basket_discounts', function (Blueprint $table) {
            $table->dropColumn('applicable_items');
        });
    }
}
