import store from '../../store';
import collect from "collect.js";

store.registerModule('basket', {
    state: {
        item_count: 0,
        basket: {},
    },
    getters: {
        isBasketLoaded: state => {
            return Object.keys(state.basket).length > 0;
        },
        isBasketValid: state => {
            return collect(state.basket.validation)
                .filter(is_valid => is_valid === false)
                .count() === 0;
        }
    },
    mutations: {
        setBasket(state, basket) {
            state.basket = basket;
            state.item_count = state.basket.items.reduce((a, b) => a + parseInt(b.quantity), 0);
        },
        basketAjax(state, url) {
            Vue.http.post(url).then(function (response) {
                state.basket = response.data.data;
                state.item_count = state.basket.items.reduce((a, b) => a + parseInt(b.quantity), 0);
                Vue.nextTick()
                    .then(function () {
                        if ($('#checkoutProcess .basketSidebar').length > 0) {
                            // checkoutSummaryFixed();
                        }
                        $('body').trigger('mtc_basket_loaded');
                    })
            });
        },
        basketRefresh(state, url) {
            Vue.http.post(url).then(function (response) {

                state.basket.items = response.data.data.items;
                state.basket.validation = response.data.data.validation;
                state.item_count = state.basket.items.reduce((a, b) => a + parseInt(b.quantity), 0);
            });
        },
        setValidationToFalse(state, section) {
            state.basket.validation[section] = false;
        }
    },
    actions: {
        updateBasket(context, basket) {
            context.commit('setBasket', basket);
        },
        loadBasket(context) {
            context.commit('basketAjax', '/basket');
        },
        loadCheckout(context) {
            context.commit('basketAjax', '/checkout');
        },
        refreshCheckout(context) {
            context.commit('basketRefresh', '/checkout');
        },
        addItem(context, purchasable) {
            Vue.http.post('/basket/add-item', {
                node_id: purchasable.node_id,
                quantity: purchasable.quantity
            }).then(function (response) {
                context.commit('setBasket', response.data.basket);
            });
        },
        updateQuantity(context, stock_amends) {
            Vue.http.post('/basket/update-item', {
                stock_amends: stock_amends
            }).then(function (response) {
                context.commit('setBasket', response.data.data);
            });
        },
        setItemPrice(context, item) {
            Vue.http.post('/basket/update-item-price', {
                id: item.id,
                price: item.custom_price
            }).then(function (response) {
                context.commit('setBasket', response.data.data);
            });
        },
        updateItemQuantity(context, item) {
            let quantity_amends = {};
            quantity_amends[item.id] = item.quantity;
            context.dispatch('updateQuantity', quantity_amends);
        },
        removeItem(context, item) {
            let quantity_amends = {};
            quantity_amends[item.id] = 0;
            context.dispatch('updateQuantity', quantity_amends);
        },
        removeMultiple(context, items) {
            let quantity_amends = {};
            items.forEach((item) => {
                quantity_amends[item.id] = 0;
            });
            context.dispatch('updateQuantity', quantity_amends);
        }

    }
});
