<?php

namespace Mtc\Basket\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Basket\Basket;

/**
 * Class LoadBasketExtensions
 *
 * @package Mtc\Basket
 */
class LoadBasketExtensions
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Basket object
     *
     * @var Basket
     */
    public $basket;

    /**
     * Create a new event instance.
     *
     * @param Basket $basket basket data
     * @return void
     */
    public function __construct($basket)
    {
        $this->basket = $basket;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
