<?php

namespace Mtc\Basket\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Basket\Contracts\BasketDetailsRequestContract;
use Mtc\Foundation\Rules\ValidPhoneNumber;

/**
 * Class BasketDetailsRequest
 * Validate request to basket detail update
 *
 * @package Mtc\Basket\Http\Requests
 */
class BasketDetailsRequest extends FormRequest implements BasketDetailsRequestContract
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // No rules by default to avoid not saving details while user is filling out details
        ];
    }
}
