<?php

namespace Mtc\Basket\Listeners;

use Mtc\Basket\Events\BasketItemCreating;

/**
 * Class AddWeightToBasketItem
 *
 * @package Mtc\Basket
 */
class AddWeightToBasketItem
{

    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle(BasketItemCreating $event)
    {
        $data = $event->basket_item->data ?? [];
        $data['weight'] = $event->basket_item->purchasable->getWeight();
        $event->basket_item->data = $data;
    }

}
