<?php

namespace Mtc\Basket;

use Illuminate\Support\Facades\App;

/**
 * Class BasketLoaderWithSessionSuperglobalFallback
 *
 * @package Mtc\Basket
 */
class BasketLoaderWithSessionSuperglobalFallback
{
    /**
     * Invoke the loader
     *
     * @return mixed
     */
    public function __invoke()
    {
        $class = config('basket.model', Basket::class);
        return App::make($class)->findOrNew(session('basket_id', $_SESSION['basket_id'] ?? 0));
    }
}
