<?php

use Illuminate\Routing\Router;
use Mtc\Basket\Http\Controllers\BasketController;
use Mtc\Basket\Http\Controllers\CheckoutController;
use Mtc\Basket\Http\Controllers\LegacyBasketController;
use Mtc\Basket\Http\Controllers\ProductFinderController;

/** @var Router $router */

$router->group([
    'prefix' => config('basket.basket_route_slug'),
    'as' => 'basket.'
], function (Router $router) {
    $router->get('/', BasketController::class . '@index')->name('index');
    $router->post('/', BasketController::class . '@show')->name('show');
    $router->post('add-item', BasketController::class . '@store')->name('add-item');
    $router->post('update-item', BasketController::class . '@update')->name('update-item');
    $router->post('update-item-price', BasketController::class . '@updatePrice')->name('update-item-price');
    $router->post('remove-discount', BasketController::class . '@destroy')->name('remove-discount');

});

$router->group([
    'prefix' => config('basket.checkout_route_slug'),
    'as' => 'checkout.'
], function (Router $router) {
    $router->get('/', CheckoutController::class . '@index')->name('index');
    $router->post('/', CheckoutController::class . '@show')->name('show');
    $router->post('/details', CheckoutController::class . '@setDetails')->name('set_details');
    $router->post('/set-address', CheckoutController::class . '@setAddress')->name('set_address');

});

// Legacy route
$router->post('/shop/addtobasket', LegacyBasketController::class . '@addShopItem')->name('add-to-basket');
$router->get('/find-product', ProductFinderController::class . '@search');
