<?php

namespace Mtc\Basket\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Basket\Contracts\BasketDetailsRequestContract;
use Mtc\Basket\Contracts\SetAddressRequest;
use Mtc\Basket\Http\Requests\SetAddress;

/**
 * Class BasketController
 *
 * @package Mtc\Basket\Http\Controllers
 */
class CheckoutController extends Controller
{
    /**
     * Show basket template
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request, BasketRepositoryInterface $basket)
    {
        if (!$basket->hasItems()) {
            return redirect()->to(route('basket.index'));
        }

        return App::make(config('basket.template_response_class'))->checkout($request, $basket);
    }

    /**
     * Return ajax response with basket contents
     *
     * @return mixed
     */
    public function show()
    {
        return App::make(config('basket.checkout_ajax_response_class'));
    }

    /**
     * Set an address on basket
     *
     * @param SetAddress $request
     * @param BasketRepositoryInterface $basket
     * @return mixed
     */
    public function setAddress(SetAddressRequest $request, BasketRepositoryInterface $basket)
    {
        $basket->setAddress($request->input('type'), $request->input());
        return App::make(config('basket.checkout_ajax_response_class'));
    }

    /**
     * Set an address on basket
     *
     * @param SetAddress $request
     * @param BasketRepositoryInterface $basket
     * @return mixed
     */
    public function setDetails(BasketDetailsRequestContract $request, BasketRepositoryInterface $basket)
    {
        $basket->setDetails($request->input());
        return App::make(config('basket.checkout_ajax_response_class'));
    }
}

