<?php

namespace Mtc\Basket\Validators;

use Illuminate\Support\Facades\Validator;
use Mtc\Foundation\Rules\ValidPhoneNumber;

/**
 * Class DetailsValidator
 *
 * @package Mtc\Basket
 */
class DetailsValidator extends BaseBasketValidator
{

    /**
     * Check if there is delivery address error
     *
     * @return bool
     */
    public function handle()
    {
        $validator = Validator::make($this->basket->toArray(), [
            'email' => 'required|email',
            'contact_number' => new ValidPhoneNumber(),
        ]);

        $this->repository->setErrors($validator->errors()->toArray());
        return $validator->passes();
    }

}
