<?php

namespace Mtc\Basket;

/**
 * Class Address
 *
 * @package Mtc\Basket
 */
class Address extends \Mtc\Foundation\Address
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'basket_addresses';

    /**
     * Touch (update) relationship when changes are made
     *
     * @var array
     */
    protected $touches = [
        'basket',
    ];

    /**
     * Relationship with Basket
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basket()
    {
        return $this->belongsTo(Basket::class);
    }
}
