<?php

namespace Mtc\Basket;

/**
 * Trait BackOrderPricing
 *
 * @package Mtc\Basket
 */
trait BackOrderPricing
{
    /**
     * Get Url attribute from purchasable attribute
     *
     * @return mixed
     */
    public function getBackorderQuantityAttribute()
    {
        return ($this->stock < $this->quantity && config('basket.allow_backorders') === true)
            ? $this->quantity - $this->stock
            : 0;
    }

    /**
     * Get Price attribute from purchasable object
     *
     * @return mixed
     */
    public function getBackorderLineTotalExVatAttribute()
    {
        if (!empty($this->attributes['custom_price'])) {
            return $this->custom_price->raw(false) * $this->backorder_quantity;
        }
        return $this->purchasable->getPrice()->raw(false) * $this->backorder_quantity;
    }

    /**
     * Get Price attribute from purchasable object
     *
     * @return mixed
     */
    public function getBackorderLineTotalAttribute($with_tax = null)
    {
        $with_tax = $with_tax ?? config('basket.subtotal_display_with_vat');
        if (!empty($this->attributes['custom_price'])) {
            return $this->custom_price->raw($with_tax) * $this->backorder_quantity;
        }
        return $this->purchasable->getPrice()->raw($with_tax) * $this->backorder_quantity;
    }

    /**
     * Get Price attribute from purchasable object
     *
     * @return mixed
     */
    public function getBackorderLineTaxAttribute()
    {
        if (!empty($this->attributes['custom_price'])) {
            return $this->custom_price->tax() * $this->backorder_quantity;
        }
        return $this->purchasable->getPrice()->tax() * $this->backorder_quantity;
    }

    /**
     * Get Price attribute from purchasable object
     *
     * @return mixed
     */
    public function getBackorderLineOriginalAttribute()
    {
        if (!empty($this->attributes['custom_price'])) {
            return $this->custom_price->raw(config('basket.subtotal_display_with_vat'))
                * $this->backorder_quantity;
        }
        return $this->purchasable->getOriginalPrice(config('basket.subtotal_display_with_vat'))->raw()
            * $this->backorder_quantity;
    }
}
