<?php

namespace Mtc\Basket\Contracts;

use Mtc\Members\Member;

/**
 * This interface defines the necessary methods for building a Basket
 *
 * @package Mtc\Basket
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @deprecated
 */
interface BasketContract
{
    /**
     * Get the addresses associated with this basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function addresses();

    /**
     * Get the addresses associated with this basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function shippingAddress();

    /**
     * Get the subtotal cost for all items in the basket.
     *
     * @return float
     */
    public function getCostSubtotalAttribute();

    /**
     * Get the subtotal cost for all items in the basket without tax.
     *
     * @return float
     */
    public function getCostSubtotalWithoutTaxAttribute();

    /**
     * Calculate the total, including any price modifiers.
     *
     * @return float
     */
    public function getCostTotalAttribute();

    /**
     * Get the list of items within the basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function items();

    /**
     * Get the list of discounts within the basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function discounts();

    /**
     * Get the list of discounts within the basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function surcharges();

    /**
     * Get the user this belongs to.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function member();

    /**
     * Set user details for basket
     *
     * @param Member $user
     */
    public function setMemberDetails(Member $user);

    /**
     * Check if user details should be updated from user account
     *
     * @return bool
     */
    public function shouldSetMemberDetails(): bool;

    /**
     * Check if basket requires delivery
     *
     * @return bool
     */
    public function getNeedsDeliveryAttribute(): bool;

    /**
     * Get the relationship to delivery information
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function deliverySurcharge();

    public function getWeight();
}
