<?php

namespace Mtc\Basket\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Basket\Contracts\BasketRepositoryInterface;

/**
 * Class LoadExternalPaymentGateways
 *
 * @package Mtc\Basket
 */
class LoadExternalPaymentGateways
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Basket object
     *
     * @var BasketRepositoryInterface
     */
    public $basket;

    /**
     * Create a new event instance.
     *
     * @param BasketRepositoryInterface $basket basket data
     * @return void
     */
    public function __construct($basket)
    {
        $this->basket = $basket;
    }
}
