<?php

namespace Mtc\Basket\Validators;

use Illuminate\Support\Facades\App;

/**
 * Class AllowShippingTypeSection
 *
 * @package Mtc\Basket
 */
class AllowShippingTypeSection extends BaseBasketValidator
{
    /**
     * Check if section is available
     *
     * @return bool
     */
    public function handle($type)
    {
        return $this->basket->needs_delivery == true
            && (
                App::make(config('basket.allow_checkout_sections.shipping_types'))->handle() == false
                || $this->basket->shipping_type == $type
            );
    }
}
