<?php

namespace Mtc\Basket\Validators;

use Mtc\ShippingManager\Facades\Shipping;

/**
 * Class AllowShippingTypes
 *
 * @package Mtc\Basket
 */
class AllowShippingTypes extends BaseBasketValidator
{
    /**
     * Check if section is available
     *
     * @return bool
     */
    public function handle()
    {
        $has_multiple_types = Shipping::enabledTypes()->count() > 1;

        return $this->basket->needs_delivery === true
            && $has_multiple_types;
    }
}
