<?php

namespace Mtc\Basket\Validators;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Foundation\Rules\ValidPhoneNumber;
use Mtc\Foundation\Rules\ValidPostcode;

/**
 * Class BasketValidator
 *
 * @package Mtc\Basket
 */
class BasketItemValidator extends BaseBasketValidator
{
    /**
     * Check if basket items are valid
     *
     * @return bool
     */
    public function handle()
    {
        if (
            config('basket.allow_backorders') !== true
            || config('basket.check_stock_on_items_when_basket_doesnt_check_stock')
        ) {
            $passes = $this->checkItemsOutOfStock();
        }

        return config('basket.allow_backorders') ? true : $passes;
    }

    /**
     * Check if stock values are ok for the basket
     *
     * @return bool
     */
    protected function checkItemsOutOfStock()
    {
        return collect($this->basket->items)
                ->filter(function ($item) {
                    $item->in_stock = $item->purchasable->getStock() >= $item->quantity;
                    return !$item->in_stock;
                })
                ->count() == 0;
    }
}
