<?php

namespace Mtc\Basket\Validators;

use Mtc\ShippingManager\Facades\Shipping;

/**
 * Class ShippingValidator
 *
 * @package Mtc\Basket
 */
class ShippingValidator extends BaseBasketValidator
{
    /**
     * Check if there is delivery address error
     *
     * @return bool
     */
    public function handle()
    {
        if (!$this->basket->needs_delivery) {
            return true;
        }

        $keys = Shipping::enabledTypes()->keys();
        return $keys->filter(function ($key) {
            return $this->repository->hasSurcharge(0, $key);
        })
            ->isNotEmpty();
    }
}
