<?php

namespace Mtc\Basket\Validators;

use Illuminate\Support\Facades\Validator;
use Mtc\Foundation\Rules\ValidPostcode;

/**
 * Class ShippingAddressValidator
 *
 * @package Mtc\Basket
 */
class ShippingAddressValidator extends BaseBasketValidator
{
    /**
     * Check if there is delivery address error
     *
     * @return bool
     */
    public function handle()
    {
        if (!$this->basket->needs_delivery) {
            return true;
        }

        if ($this->basket->shipping_type === 'delivery') {
            $address = $this->basket->shippingAddress ? $this->basket->shippingAddress->toArray() : [];
            $validator = Validator::make($address, [
                'type' => 'required',
                'first_name' => 'required',
                'last_name' => 'required',
                'address1' => 'required',
                'city' => 'required',
                'country' => 'required|exists:countries,code',
                'postcode' => new ValidPostcode($address['country'] ?? ''),
            ]);

            return $validator->passes();
        }

        return $this->basket->surcharges->where('surcharge_type', 'collection')->isNotEmpty();
    }
}
