<?php

namespace Mtc\Basket\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Basket\Item;

/**
 * Class BasketItemCreating
 *
 * @package Mtc\Basket
 */
class BasketItemCreating
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Basket object
     *
     * @var Item
     */
    public $basket_item;

    /**
     * Create a new event instance.
     *
     * @param Item $basket_item
     * @return void
     */
    public function __construct($basket_item)
    {
        $this->basket_item = $basket_item;
    }
}
