<?php

namespace Mtc\Basket\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;

/**
 * Class BasketAjax
 *
 * @package Mtc\Basket\Http\Resources
 */
class ProductSearchResponse extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource = $this->resource
            ->flatten(1)
            ->filter(function ($purchasable) {
                return $purchasable->size || empty($purchasable->sizes()->count());
            })
            ->take($request->input('limit', 20))
            ->each(function ($purchasable) {
                $purchasable->price = $purchasable->getPrice()->raw();

                if (empty($purchasable->node_id)) {
                    $purchasable->node_id = optional($purchasable->node)->id;
                }

                $purchasable->setVisible([
                    'node_id',
                    'attribute_values',
                    'search_name',
                    'name',
                    'price',
                    'sku',
                    'basket_image',
                    'stock',
                    'size',
                ]);
            });

        return parent::toArray($request);
    }
}
