<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBasketsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('baskets', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('member_id')->nullable()->index();
            $table->string('email')->nullable()->index();
            $table->string('contact_number')->nullable();
            $table->string('secondary_phone_number')->nullable();
            $table->boolean('newsletter_signup')->nullable();
            $table->text('message')->nullable();
            $table->text('additional_info')->nullable();
            $table->text('tracking_data')->nullable();
            $table->timestamps();
        });

        Schema::create('basket_items', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('basket_id')->index();
            $table->morphs('purchasable');
            $table->unsignedInteger('quantity')->index();
            $table->string('sku', 100)->nullable()->index();
            $table->text('attribute_fields')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::create('basket_item_lines', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('basket_item_id')->index();
            $table->string('reference')->nullable()->index();
            $table->string('name');
            $table->text('data')->nullable();
            $table->string('sku')->nullable();
            $table->timestamps();
        });

        Schema::create('basket_addresses', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('basket_id')->nullable()->index();
            $table->string('type', 20)->index();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('address1')->nullable();
            $table->string('address2')->nullable();
            $table->string('city')->nullable();
            $table->string('county')->nullable();
            $table->string('postcode')->nullable();
            $table->string('country');
            $table->string('state')->nullable();
            $table->timestamps();
        });

        Schema::create('basket_discounts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('basket_id')->nullable()->index();
            $table->morphs('discount');
            $table->timestamps();
        });

        Schema::create('basket_surcharges', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('basket_id')->nullable()->index();
            $table->morphs('surcharge');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('baskets');
        Schema::dropIfExists('basket_items');
        Schema::dropIfExists('basket_item_lines');
        Schema::dropIfExists('basket_addresses');
        Schema::dropIfExists('basket_discounts');
        Schema::dropIfExists('basket_surcharges');
    }
}
