<div class="flex h-full w-full flex-1 flex-col gap-4 rounded-xl">
    <div class="grid auto-rows-min gap-4 md:grid-cols-1">
        <div class="relative h-full flex-1 overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
            <div class="max-w-2xl mx-auto mt-10 p-6 bg-white rounded-lg shadow-md border border-zinc-200">
                <!-- Stepper Navigation -->
                <div class="flex items-center mb-8">
                    <div class="flex-1">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full flex items-center justify-center font-bold text-white {{ $step === 1 ? 'bg-accent' : 'bg-zinc-400' }}">1</div>
                            <span class="ml-2 text-black font-semibold">Carrier Info</span>
                        </div>
                    </div>
                    <div class="flex-1 border-t-2 mx-2 border-zinc-200"></div>
                    <div class="flex-1">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full flex items-center justify-center font-bold text-white {{ $step === 2 ? 'bg-accent' : 'bg-zinc-400' }}">2</div>
                            <span class="ml-2 text-black font-semibold">Rates</span>
                        </div>
                    </div>
                    <div class="flex-1 border-t-2 mx-2 border-zinc-200"></div>
                    <div class="flex-1">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full flex items-center justify-center font-bold text-white {{ $step === 3 ? 'bg-accent' : 'bg-zinc-400' }}">3</div>
                            <span class="ml-2 text-black font-semibold">Review</span>
                        </div>
                    </div>
                </div>

                <!-- Step 1: Carrier Info -->
                @if($step === 1)
                    <form wire:submit.prevent="nextStep" class="space-y-4">
                        <div>
                            <label for="carrier_info_code" class="block text-sm font-medium text-black mb-1">Carrier Code</label>
                            <input type="text" id="carrier_info_code" wire:model="carrier_info_code"
                                   class="w-full px-3 py-2 border border-zinc-300 rounded-md focus:outline-none focus:ring-2 focus:ring-accent focus:border-accent text-black" />
                            @error('carrier_info_code') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="carrier_info_display_name" class="block text-sm font-medium text-black mb-1">Carrier Display Name</label>
                            <input type="text" id="carrier_info_display_name" wire:model="carrier_info_display_name"
                                   class="w-full px-3 py-2 border border-zinc-300 rounded-md focus:outline-none focus:ring-2 focus:ring-accent focus:border-accent text-black" />
                            @error('carrier_info_display_name') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
                        </div>
                        <div class="flex justify-end">
                            <button type="submit" class="bg-accent text-black font-semibold py-2 px-4 rounded-md hover:bg-accent-700 transition-colors">Next</button>
                        </div>
                    </form>
                @endif

                <!-- Step 2: Add Rates -->
                @if($step === 2)
                    <div class="mb-4">
                        <form wire:submit.prevent="addRate" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                            <div>
                                <label class="block text-sm text-black mb-1">Code</label>
                                <input type="text" wire:model="rate_code" class="w-full px-2 py-1 border border-zinc-300 rounded text-black" />
                            </div>
                            <div>
                                <label class="block text-sm text-black mb-1">Description</label>
                                <input type="text" wire:model="rate_description" class="w-full px-2 py-1 border border-zinc-300 rounded text-black" />
                            </div>
                            <div>
                                <label class="block text-sm text-black mb-1">Currency</label>
                                <select wire:model="rate_currency" class="w-full px-2 py-1 border border-zinc-300 rounded text-black">
                                    <option value="">Select currency</option>
                                    @foreach($currencies as $currency)
                                        <option value="{{ $currency }}">{{ $currency }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm text-black mb-1">Amount</label>
                                <input type="number" step="0.01" wire:model="rate_amount" class="w-full px-2 py-1 border border-zinc-300 rounded text-black" />
                            </div>
                            <div class="md:col-span-4 flex justify-end mt-2">
                                <button type="submit" class=" cursor-pointer bg-accent text-black font-semibold py-1 px-4 rounded hover:bg-accent-700 transition-colors">Add Rate</button>
                            </div>
                        </form>
                    </div>
                    <div>
                        <h4 class="text-black font-semibold mb-2">Rates Added</h4>
                        <ul>
                            @forelse($rates as $i => $rate)
                                <li class="flex items-center justify-between bg-zinc-100 rounded p-2 mb-2">
                                    <span class="text-black">{{ $rate['code'] }} ({{ $rate['currency'] }} {{ $rate['amount'] }}) - {{ $rate['description'] }}</span>
                                    <button wire:click="removeRate({{ $i }})" class="text-red-500 hover:underline ml-2">Remove</button>
                                </li>
                            @empty
                                <li class="text-zinc-400">No rates added yet.</li>
                            @endforelse
                        </ul>
                    </div>
                    <div class="flex justify-between mt-4">
                        <button wire:click="prevStep" class="bg-zinc-300 text-black font-semibold py-2 px-4 rounded-md hover:bg-zinc-400 transition-colors">Back</button>
                        <button wire:click="nextStep" class="bg-accent text-black font-semibold py-2 px-4 rounded-md hover:bg-accent-700 transition-colors">Next</button>
                    </div>
                @endif

                <!-- Step 3: Review & Confirm -->
                @if($step === 3)
                    <div class="mb-4">
                        <h4 class="text-black font-semibold mb-2">Carrier Info</h4>
                        <div class="bg-zinc-100 rounded p-3 mb-2">
                            <div><span class="font-bold">Code:</span> {{ $carrier_info_code }}</div>
                            <div><span class="font-bold">Display Name:</span> {{ $carrier_info_display_name }}</div>
                        </div>
                        <h4 class="text-black font-semibold mb-2">Rates</h4>
                        <ul>
                            @forelse($rates as $rate)
                                <li class="bg-zinc-100 rounded p-2 mb-2">
                                    <span class="text-black">{{ $rate['code'] }} ({{ $rate['currency'] }} {{ $rate['amount'] }}) - {{ $rate['description'] }}</span>
                                </li>
                            @empty
                                <li class="text-zinc-400">No rates added.</li>
                            @endforelse
                        </ul>
                    </div>
                    <div class="flex justify-between mt-4">
                        <button wire:click="prevStep" class="bg-zinc-300 text-black font-semibold py-2 px-4 rounded-md hover:bg-zinc-400 transition-colors">Back</button>
                        <button wire:click="saveCarrierWithRates" class="bg-green-600 text-black font-semibold py-2 px-4 rounded-md hover:bg-green-700 transition-colors">Finish</button>
                    </div>
                @endif
            </div>
        </div>
    </div>


    <div class="relative h-full flex-1 overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
        <!-- Nicer Carrier List -->
        <div class="mx-auto mt-10 px-4 z-30 ">
            <h3 class="mb-4 text-xl font-bold text-black">Added Carriers</h3>
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6 text-black">
                @forelse($carriers as $carrier)
                    <div class="bg-white border border-zinc-200 rounded-lg shadow p-6 flex flex-col justify-between h-full">
                        <div>
                            <div class="font-bold text-black text-lg mb-1">{{ $carrier->carrier_info_display_name }}</div>
                            <div class="text-zinc-500 text-sm mb-2">Code: {{ $carrier->carrier_info_code }}</div>
                            <div class="mb-2">
                            <span class="inline-block bg-accent text-white text-xs px-2 py-1 rounded">
                                {{ $carrier->rates->count() }} Rate{{ $carrier->rates->count() !== 1 ? 's' : '' }}
                            </span>
                            </div>
                        </div>
                        <div class="flex items-center justify-between mt-4">
                            <button wire:click="showCarrierModal({{ $carrier->id }})" class="group bg-accent text-black px-4 py-2 rounded hover:bg-accent-700 hover:visible cursor-pointer transition-colors flex items-center">
                                View Details
                                <svg class="w-5 h-5 ml-2 opacity-0 group-hover:opacity-100 transition-opacity" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 12H3m6-6l-6 6 6 6"/></svg>
                            </button>
                            <button wire:click="deleteCarrier({{ $carrier->id }})" class="group text-red-600 ml-4 flex items-center cursor-pointer" onclick="return confirm('Are you sure you want to delete this carrier?')">
                                Delete Carrier
                                <svg class="w-5 h-5 ml-2 opacity-0 group-hover:opacity-100 transition-opacity" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                            </button>
                        </div>
                    </div>
                @empty
                    <div class="text-zinc-400 col-span-full">No carriers added yet.</div>
                @endforelse
            </div>
            <div class="mt-6">
                {{ $carriers->links() }}
            </div>
        </div>

        <!-- Modal for Carrier Details -->
        @if($showModal && $selectedCarrier)
            <div class="fixed inset-0 z-50 flex items-center justify-center bg-black bg-opacity-50 backdrop-blur-md">
                <div class="bg-white rounded-lg shadow-lg max-w-lg w-full p-6 relative border border-zinc-200 backdrop-blur-md">
                    <div class="flex items-center justify-between mb-4 pr-8">
                        <div>
                            <div class="font-bold text-xl text-black mb-1">{{ $selectedCarrier->carrier_info_display_name }}</div>
                            <div class="text-zinc-500 text-sm mb-2">Code: {{ $selectedCarrier->carrier_info_code }}</div>
                        </div>
                        <button wire:click="closeModal" class="cursor-pointer group text-black hover:text-zinc-700 text-3xl font-bold focus:outline-none ml-8 flex items-center" style="z-index: 60;">
                            &times;
                            <svg class="w-5 h-5 ml-2 opacity-0 group-hover:opacity-100 transition-opacity" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                        </button>
                    </div>
                    <div class="mx-auto mt-10 px-4">
                        <div class="flex items-center justify-between mb-2">
                            <button wire:click="toggleAddRateForm" class="cursor-pointer text-accent font-semibold px-3 py-1 rounded hover:bg-accent text-black transition-colors">
                                {{ $showAddRateForm ? 'Hide' : 'Add Rate' }}
                            </button>
                        </div>
                        @if($showAddRateForm)
                            <form wire:submit.prevent="addRateToCarrier" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end mb-4">
                                <div>
                                    <label class="block text-sm text-black mb-1">Code</label>
                                    <input type="text" wire:model="modal_rate_code" class="w-full px-2 py-1 border border-zinc-300 rounded text-black" />
                                </div>
                                <div>
                                    <label class="block text-sm text-black mb-1">Description</label>
                                    <input type="text" wire:model="modal_rate_description" class="w-full px-2 py-1 border border-zinc-300 rounded text-black" />
                                </div>
                                <div>
                                    <label class="block text-sm text-black mb-1">Currency</label>
                                    <select wire:model="modal_rate_currency" class="w-full px-2 py-1 border border-zinc-300 rounded text-black">
                                        <option value="">Select currency</option>
                                        @foreach($currencies as $currency)
                                            <option value="{{ $currency }}">{{ $currency }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm text-black mb-1">Amount</label>
                                    <input type="number" step="0.01" wire:model="modal_rate_amount" class="w-full px-2 py-1 border border-zinc-300 rounded text-black" />
                                </div>
                                <div class="md:col-span-4 flex justify-end mt-2">
                                    <button type="submit" class="bg-accent text-black font-semibold py-1 px-4 rounded hover:bg-accent-700 transition-colors cursor-pointer">Add Rate</button>
                                </div>
                            </form>
                        @endif
                        <div class="flex justify-end mb-4">
                            <button wire:click="finishAddingRates" class="bg-green-600 text-white font-semibold py-2 px-4 rounded-md hover:bg-green-700 transition-colors">Finish</button>
                        </div>
                        <div class="font-semibold text-black mb-2">Rates</div>
                        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-2 gap-6 text-black">
                            @forelse($paginatedRates as $rate)
                                <div class="bg-zinc-100 border border-zinc-200 rounded p-4 flex flex-col justify-between">
                                    <div>
                                        <div class="font-bold text-black">Code: {{ $rate->code }}</div>
                                        <div class="font-bold text-black">Rate Unique Id: {{ $rate->rate_id }}</div>
                                        <div class="text-zinc-500 text-sm mb-1">Description: {{ $rate->display_name }}</div>
                                        @if($rate->rateCost)
                                            <div class="text-black text-sm">Cost: <span class="font-mono">{{ $rate->rateCost->currency }} {{ $rate->rateCost->amount }}</span></div>
                                        @endif
                                    </div>
                                    <button wire:click="deleteRate({{ $rate->id }})" class="group text-red-600 mt-2 self-end flex items-center cursor-pointer" onclick="return confirm('Are you sure you want to delete this rate?')">
                                        Delete Rate
                                        <svg class="w-5 h-5 ml-2 opacity-0 group-hover:opacity-100 transition-opacity" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                                    </button>
                                </div>
                            @empty
                                <div class="text-zinc-400 col-span-full">No rates for this carrier.</div>
                            @endforelse
                        </div>
                        <div class="mt-4">
                            {{ $paginatedRates->links() }}
                        </div>
                    </div>
                    <div class="flex justify-end">
                        <button wire:click="closeModal" class="cursor-pointer bg-zinc-300 text-black font-semibold py-2 px-4 rounded-md hover:bg-zinc-400 transition-colors hover">Close</button>
                    </div>
                </div>
            </div>
        @endif


    </div>


</div>
