<?php

use Illuminate\Support\Facades\Route;
use Mtc\BigCommerceRates\Http\Middleware\JwtAuthenticate;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Product\Import as ProductImport;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Carrier;
use App\Http\Livewire\Dashboard; // or your package's component


    Route::view('dashboard-iframe', 'dashboard')
        ->middleware([JwtAuthenticate::class, 'auth', 'verified'])
        ->name('dashboard.iframe');

    Route::middleware(['web', JwtAuthenticate::class,'auth'])->group(function () {
        Route::get('productImport/{storeHash}', ProductImport::class)->name('productImport');
        Route::any('carrier/{storeHash}', Carrier::class)->name('carrier');
//        Route::get('productImport', ProductImport::class)->name('productImport');
    });
