<?php

    namespace Mtc\BigCommerceRates\Models\BigCommerce\Rates;

    use Illuminate\Database\Eloquent\Model;

    class RateDetails extends Model
    {
        // Explicit table name to match migration
        protected $table = 'rate_details';

        // Mass assignable fields
        protected $fillable = [
            'carrier_id',
            'code',
            'rate_id',
            'display_name',
        ];

        /**
         * Get the rate type that owns this rate detail.
         */
        public function rateType()
        {
            return $this->belongsTo(StoreCarrier::class, 'carrier_id');
        }

        /**
         * Get the cost(s) for this rate detail.
         */
        public function rateCost()
        {
            return $this->hasOne(RateCost::class, 'rate_details_id');
        }
    }
