<?php
namespace Mtc\BigCommerceRates\Providers\BigCommerce;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\BigCommerceRates\Console\Commands\ImportProducts;
use Livewire\Livewire;

use Illuminate\Support\Facades\View;


use Mtc\BigCommerceRates\Livewire\BigCommerce\Carrier;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Product\Import as ProductImport;

class Resources extends ServiceProvider
{
	public function register()
	{

	}

    public function loadMenus()
    {
        View::composer('components.layouts.app.sidebar', function ($view) {
                $menus = $view->sidebarExtraMenus ?? [];
                $menus[] = view('bigcommerce::sidebar.extra-menus')->render();
                $view->with('sidebarExtraMenus', $menus);
            });
    }

    protected function registerLivewireComponentsFrom($directory, $namespace, $aliasPrefix = '')
    {
        foreach (glob($directory . '/*.php') as $file) {
            $class = $namespace . '\\' . pathinfo($file, PATHINFO_FILENAME);

            // Convert namespace and class to kebab-case alias
            $alias = $aliasPrefix . ltrim(str_replace(['\\', 'Livewire\\'], ['.', ''], $class), '.');
            $alias = strtolower(preg_replace('/([a-z])([A-Z])/', '$1-$2', $alias)); // camelCase to kebab-case

            if (is_subclass_of($class, \Livewire\Component::class)) {
                \Livewire\Livewire::component($alias, $class);
            }
        }

        // Recursively register components in subdirectories
        foreach (glob($directory . '/*', GLOB_ONLYDIR) as $subdir) {
            $subNamespace = $namespace . '\\' . basename($subdir);
            $subAliasPrefix = $aliasPrefix . strtolower(basename($subdir)) . '.';
            $this->registerLivewireComponentsFrom($subdir, $subNamespace, $subAliasPrefix);
        }
    }


    public function loadLivewireComponents()
    {
          Livewire::component('bigcommerce.product.import', ProductImport::class);
          Livewire::component('bigcommerce.rates.carrier', Carrier::class);
    }

	public function boot()
	{

		//Publish Database assets
		$this->publishes([
            __DIR__.'/../../../database/migrations/' => database_path('migrations'),
            // __DIR__.'/../../../database/seeders/' => database_path('seeders')

        ],"database");

        $this->loadViewsFrom(__DIR__.'/../../../resources/views', 'bigcommerce');
        // Reference views
        // Register all Livewire components in the package
        $this->registerLivewireComponentsFrom(
            __DIR__ . '/../../Livewire',
            'Mtc\\BigCommerceRates\\Livewire'
        );
        $this->loadMenus();


         // Publish assets
        /*$this->publishes([
            __DIR__.'/../../../resources/js' => public_path('js'),
            __DIR__.'/../../../resources/css' => public_path('css'),
        ], 'assets');*/

        // Register console commands only when running in the console
        if ($this->app->runningInConsole()) {
            $this->commands([
                ImportProducts::class,
            ]);
        }

	}
}
