<?php

namespace App\Services;

use App\Interfaces\Carrier;
use App\Models\BigCommerce\Rates\StoreCarrier;

class CarrierService implements Carrier
{

    /**
     * Create a new class instance.
     */
    public function __construct(
        private StoreCarrier $storeCarrier,
    )
    {
    }

    public function getCarrierCode(): string
    {
        return $this->storeCarrier->carrier_info_code ?? '';
    }

    public function getCarrierName(): string
    {
        return $this->storeCarrier->carrier_info_display_name ?? '';
    }

    public function setCarrierCode(string $code)
    {
        $this->storeCarrier->carrier_info_code = $code;
        $this->storeCarrier->save();
    }

    public function setCarrierName(string $name)
    {
        $this->storeCarrier->carrier_info_display_name = $name;
        $this->storeCarrier->save();
    }
}
