<?php

    namespace Mtc\BigCommerceRates\Models\BigCommerce\Rates;

    use Illuminate\Database\Eloquent\Model;

    class RateCost extends Model
    {
        // Explicit table name
        protected $table = 'rate_details_costs';

        // Mass assignable fields
        protected $fillable = [
            'rate_details_id',
            'currency',
            'amount',
        ];

        /**
         * Get the rate detail this cost belongs to.
         */
        public function rateDetail()
        {
            return $this->belongsTo(RateDetails::class, 'rate_details_id');
        }
    }
