<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_product', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("store_id");
            $table->string("sku")->index()->nullable()->default(null)->comment("Product SKU");
            $table->integer("product_id")->index()->comment("Product Id");
            $table->string("name")->index()->comment("Product Name");
            $table->string("price")->comment("Product Price");
            $table->json("custom_fields")->nullable()->default(null)->index()->comment("BigCommerce Custom Fields");
            $table->timestamps();

            $table->foreign("store_id")
                ->references("id")->on("store_installations")
                ->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_product');
    }
};
