    <div class="flex h-full w-full flex-1 flex-col gap-4 rounded-xl">
        <div class="grid auto-rows-min gap-4 md:grid-cols-3">
            <div class="relative aspect-video overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700 flex items-center justify-center">
                <button
                    wire:click="importProducts"
                    wire:loading.attr="disabled"
                    class="relative z-10 px-6 py-3 bg-gradient-to-r from-blue-600 to-blue-500 text-white font-semibold rounded-lg shadow-lg flex items-center gap-2 transition-all duration-200 hover:from-blue-700 hover:to-blue-600 hover:scale-105 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-offset-2 cursor-pointer"
                >
                    <!-- Icon (Heroicon: Arrow Down Tray) -->
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                      <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5M7.5 12l4.5 4.5m0 0l4.5-4.5m-4.5 4.5V3" />
                    </svg>
                    <span>Import Products</span>
                    <!-- Loading Spinner -->
                    <svg wire:loading wire:target="importProducts" class="animate-spin ml-2 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                      <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                      <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                    </svg>
                </button>
            </div>
            <div class="relative aspect-video overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
                <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/20 dark:stroke-neutral-100/20" />
            </div>
            <div class="relative aspect-video overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
                <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/20 dark:stroke-neutral-100/20" />
            </div>
        </div>
        @if (session('success'))
            <div class="p-4 mt-4 bg-green-100 text-green-800 rounded dark:bg-green-800 dark:text-green-100">{{ session('success') }}</div>
        @endif
        @if (session('error'))
            <div class="p-4 mt-4 bg-red-100 text-red-800 rounded dark:bg-red-800 dark:text-red-100">{{ session('error') }}</div>
        @endif
        <div class="relative h-full flex-1 overflow-auto rounded-xl border border-neutral-200 dark:border-neutral-700">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-300 dark:bg-neutral-800">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-neutral-500 uppercase tracking-wider dark:text-neutral-400">
                                Name
                            </th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-neutral-500 uppercase tracking-wider dark:text-neutral-400">
                                SKU
                            </th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-neutral-500 uppercase tracking-wider dark:text-neutral-400">
                                Price
                            </th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-neutral-500 uppercase tracking-wider dark:text-neutral-400">
                                Imported At
                            </th>
                        </tr>
                    </thead>
                    <tbody >
                        @forelse ($products as $product)
                            <tr class="cursor-pointer odd:bg-gray-100 even:bg-white hover:bg-gray-200 bg-white dark:bg-neutral-800">
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-neutral-900 dark:text-black">
                                    {{ $product->name }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-neutral-500 dark:text-black">
                                    {{ $product->sku }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-neutral-500 dark:text-black">
                                    {{ number_format($product->price, 2) }}
                                </td>
                                 <td class="px-6 py-4 whitespace-nowrap text-sm text-neutral-500 dark:text-black">
                                    {{ $product->created_at->format('M d, Y H:i') }}
                                </td>
                            </tr>
                        @empty
                            <tr class="bg-white dark:bg-neutral-800">
                                <td colspan="4" class="px-6 py-4 whitespace-nowrap text-sm text-center text-neutral-500 dark:text-neutral-400">
                                    No products have been imported yet. Click the button to start importing.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="p-4 text-neutral-700 dark:text-neutral-300">
                {{ $products->links() }}
            </div>
        </div>
    </div>
