<?php

namespace Mtc\BigCommerceRates\Providers\BigCommerce;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        $this->mapApiRoutes();
        $this->mapBigCRoutes();
        $this->mapWebhookRoutes();
        $this->mapBigCWebRoutes();
    }



    protected function mapBigCRoutes()
    {
        Route::prefix('biginstall')
            ->middleware('api')
            ->group(__DIR__ . '/../../../routes/bigcommerce.php');
    }

    protected function mapApiRoutes()
    {
        // bc-api routes
        Route::prefix('bc-api')
            ->middleware('api')
            ->group(__DIR__ . '/../../../routes/api-bigcommerce.php');
    }

    protected function mapBigCWebRoutes()
    {
        $this->loadRoutesFrom(__DIR__ . '/../../../routes/web-bigcommerce.php');
    }

    protected function mapWebhookRoutes(){
        // webhook routes
        Route::prefix('webhook')
            ->middleware('api')
            ->group(__DIR__ . '/../../../routes/webhook.php'); // Assuming webhook routes are in routes/webhook.php
    }

}
