<?php

namespace Mtc\BigCommerceRates\Models;

use Illuminate\Database\Eloquent\Model;

class StoreInstallation extends Model
{
    protected $fillable = [
        'store_hash',
        'auth_code',
        'scopes',
        'access_token',
        'refresh_token',
        'token_expires_at',
    ];

    protected $casts = [
        'scopes' => 'array',
        'token_expires_at' => 'datetime',
    ];

    /**
     * Check if the installation is valid
     *
     * @return bool
     */
    public function isValid(): bool
    {
        return !empty($this->access_token) &&
               $this->token_expires_at ;
    }

    /**
     * Delete a store installation by store hash
     *
     * @param string $storeHash
     * @return bool
     */
    public static function deleteByHash(string $storeHash): bool
    {
        return self::where('store_hash', $storeHash)->delete() > 0;
    }

    /**
     * Find a store installation by store hash
     *
     * @param string $storeHash
     * @return self|null
     */
    public static function findByStoreHash(string $storeHash): ?self
    {
        return static::where('store_hash', $storeHash)->first();
    }
}
