<?php

    namespace Mtc\BigCommerceRates\Configuration;

    class Configuration
    {
        public function getAppSecret()
        {
            return match (env('APP_ENV')) {
                "local" => env('BIGCOMMERCE_APP_CLIENT_SECRET'),
                "production" => env('BIGCOMMERCE_APP_CLIENT_SECRET'),
                default => env('BIGCOMMERCE_APP_CLIENT_SECRET'),
            };
        }

        public function getAppClientId()
        {
            return match (env('APP_ENV')) {
                "local" => env('BIGCOMMERCE_APP_CLIENT_ID'),
                "production" => env('BIGCOMMERCE_APP_CLIENT_ID'),
                default => env('BIGCOMMERCE_APP_CLIENT_ID')
            };
        }

        public function getStoreHash()
        {
            return match (env('APP_ENV')) {
                "local", "production" => env('BC_LOCAL_STORE_HASH'),
                default => env('BC_APP_STORE_HASH')
            };
        }

        public function getAccessToken()
        {
            return match (env('APP_ENV')) {
                "local", "production" => env('BC_LOCAL_ACCESS_TOKEN'),
                default => env('BC_LOCAL_ACCESS_TOKEN'),
            };
        }
    }
