<?php

namespace Mtc\BigCommerceRates\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class DebugRequestMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        Log::debug('=== INCOMING REQUEST ===', [
            'path' => $request->path(),
            'method' => $request->method(),
            'headers' => $request->headers->all(),
        ]);

        $response = $next($request);

        Log::debug('=== OUTGOING RESPONSE ===', [
            'status' => $response->getStatusCode(),
            'headers' => $response->headers->all(),
        ]);

        return $response;
    }
} 