<?php

namespace Mtc\BigCommerceRates\Http\Controllers\BigCommerce\Shipping;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class CarrierController extends Controller
{
    public function rates(Request $request)
    {
        $options = [];
        $shipping = '';
        $normalItems = [];
        $multiplier = array_reduce($request->input('base_options.items', []), function($r, $c) use(&$shipping, &$normalItems) {
            $isNormalItem = true;

            foreach($c['attributes'] as $attr) {
                switch($attr['key']) {
                    case 'max_items_per_consignment':
                        $r += ceil($c['quantity'] / $attr['value']);
                        $isNormalItem = false;
                        break;
                    case 'shipping':
                        if(!empty($attr['value'])) {
                            if(empty($shipping)) {
                                $shipping = $attr['value'];
                            } else if($shipping !== $attr['value']) {
                                $shipping = 'none';
                            }
                        }
                        break;
                }
            }

            if($isNormalItem) {
                $normalItems[] = $c;
            }

            return $r;
        }, 0);


        if(!empty($normalItems)) {
            $multiplier++;
        }


    }
    public function validateConnection(Request $request)
    {
        return response()->json([
            'valid' => true,
            'messages' => [],
        ]);
    }
}
