<?php

    namespace Mtc\BigCommerceRates\Models\BigCommerce\Rates;

    use Illuminate\Database\Eloquent\Model;

    class RateDetails extends Model
    {
        // Explicit table name to match migration
        protected $table = 'rate_details';

        // Mass assignable fields
        protected $fillable = [
            'rate_details_id',
            'code',
            'rate_id',
            'description',
        ];

        /**
         * Get the rate type that owns this rate detail.
         */
        public function rateType()
        {
            return $this->belongsTo(StoreCarrier::class, 'rate_details_id');
        }
    }
