<?php

    namespace  Mtc\BigCommerceRates\Traits;


    use Illuminate\Support\Str;

    trait BigCommerceUser
    {
        protected $extraFillable = [
            'store_id',
            'platform_type'
        ];

        /**
         * Merge extra fillable fields with the model's fillable
         */
        public function initializeBigCommerceUser()
        {
            $this->fillable = array_unique(array_merge($this->fillable, $this->extraFillable));
        }


        /**
         * Get the identifier that will be stored in the subject claim of the JWT.
         */
        public function getJWTIdentifier()
        {
            return $this->getKey();
        }

        /**
         * Return a key value array, containing any custom claims to be added to the JWT.
         */
        public function getJWTCustomClaims()
        {
            return [];
        }


        /**
         * Get the store installation for the user.
         */
        public function storeInstallation()
        {
            return $this->belongsTo(\Mtc\BigCommerceRates\Models\StoreInstallation::class, 'store_id');
        }
    }
