<?php

use Illuminate\Support\Facades\Route;
use Mtc\BigCommerceRates\Http\Controllers\BigCommerce\Proxy as BigCommerceProxy;
use Mtc\BigCommerceRates\Http\Controllers\BigCommerce\Shipping\CarrierController as ShippingCarrierController;

    Route::group([
        'prefix' => '',
        'middleware' => 'api',
    ], function () {
        Route::any(
            '/{store_hash}/{endpoint}',
            [
                BigCommerceProxy::class,
                'proxyBigCommerceAPIRequest'
            ]
        )->where('endpoint', 'v2/.*|v3/.*');

        Route::group([
            'prefix' => 'shipping',
            'middleware' => 'api'
        ], function (){
            Route::post('validate-connection', [ShippingCarrierController::class, 'validateConnection']) ->name('validate-connection');
            Route::post('rates',  [ShippingCarrierController::class, 'rates'])->name('rates');
            Route::get('available-shipping-types', [ShippingCarrierController::class, 'availableShippingTypes'])->name('available-shipping-types');
        });
    });
