<?php

    namespace Mtc\BigCommerceRates\Models\BigCommerce\Rates;

    use Illuminate\Database\Eloquent\Model;
    use Mtc\BigCommerceRates\Models\StoreInstallation;

    class StoreCarrier extends Model
    {
        protected $table = 'store_carrier';

        protected $fillable = [
            'store_id',
            'rate_id',
            'carrier_info_code',
            'carrier_info_display_name',
        ];

        /**
         * Get the store installation this carrier belongs to.
         */
        public function storeInstallation()
        {
            return $this->belongsTo(StoreInstallation::class, 'store_id');
        }

        /**
         * Get the rate detail this carrier is linked to.
         */
        public function rateDetail()
        {
            return $this->belongsTo(RateDetails::class, 'rate_id');
        }
    }
