<?php
namespace Mtc\BigCommerceRates\Providers\BigCommerce;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\BigCommerceRates\Console\Commands\ImportProducts;
use Livewire\Livewire;

use Illuminate\Support\Facades\View;



use Mtc\BigCommerceRates\Livewire\BigCommerce\Product\Import as ProductImport;

class Resources extends ServiceProvider
{
	public function register()
	{

	}

    public function loadMenus()
    {
        View::composer('components.layouts.app.sidebar', function ($view) {
                $menus = $view->sidebarExtraMenus ?? [];
                $menus[] = view('bigcommerce::sidebar.extra-menus')->render();
                $view->with('sidebarExtraMenus', $menus);
            });
    }


    public function loadLivewireComponents()
    {
          Livewire::component('bigcommerce.product.import', ProductImport::class);
    }

	public function boot()
	{

		//Publish Database assets
		$this->publishes([
            __DIR__.'/../../../database/migrations/' => database_path('migrations'),
            // __DIR__.'/../../../database/seeders/' => database_path('seeders')

        ],"database");

        $this->loadViewsFrom(__DIR__.'/../../../resources/views', 'bigcommerce');
        // Reference views
        $this->loadLivewireComponents();
        $this->loadMenus();


         // Publish assets
        /*$this->publishes([
            __DIR__.'/../../../resources/js' => public_path('js'),
            __DIR__.'/../../../resources/css' => public_path('css'),
        ], 'assets');*/

        // Register console commands only when running in the console
        if ($this->app->runningInConsole()) {
            $this->commands([
                ImportProducts::class,
            ]);
        }

	}
}
