<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_carrier', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("store_id");
            $table->string('carrier_info_code')->index()->comment('Carrier Information Code');
            $table->string('carrier_info_display_name')->index()->comment('Carrier Display Name');
            $table->timestamps();


            $table->foreign("store_id")
                ->references("id")->on("store_installations")
                ->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_carrier');
    }

};
