<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rate_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("carrier_id");
            $table->string('code')->index()->comment('Rate Code');
            $table->string('rate_id')->index()->comment('Rate ID');
            $table->string('display_name')->index()->comment('Rate name to display');
            $table->timestamps();

            $table->foreign("carrier_id")
                ->references("id")->on("store_carrier")
                ->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rate_details');
    }
};
