<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rate_details_costs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("rate_details_id");
            $table->string('currency')->index()->comment('Rate Currency');
            $table->float('amount')->index()->default(0)->comment('Amount');
            $table->timestamps();

            $table->foreign("rate_details_id")
                ->references("id")->on("rate_details")
                ->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rate_details_costs');
    }
};
