<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('product_rates')) {
            Schema::create('product_rates', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger("rate_details_id");
                $table->unsignedBigInteger("store_product_id");
                $table->timestamps();
                $table->unique(['rate_details_id','store_product_id']);

                $table->foreign("rate_details_id")
                    ->references("id")->on("rate_details")->onDelete("cascade");

                $table->foreign("store_product_id")
                    ->references("id")->on("store_product")->onDelete("cascade");
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_rates');
    }
};
