<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('rates_to_country')) {
            Schema::create('rates_to_country', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger("rate_details_id");
                $table->unsignedBigInteger("country_iso2");
                $table->timestamps();
                $table->unique(['rate_details_id','country_iso2']);

                $table->foreign("rate_details_id")
                    ->references("id")->on("rate_details")->onDelete("cascade");

            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rates_to_country');
    }
};
